<?php
// etseo_engine_config.php
declare(strict_types=1);

function etseo_engine_cors_headers(): void {
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: POST, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, Authorization');
    header('Content-Type: application/json; charset=utf-8');
}

function etseo_engine_respond(array $data, int $code = 200): void {
    http_response_code($code);
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}

// Opțional: cheie simplă (Bearer) - dacă vrei să protejezi endpoint-ul
define('ETSEO_ENGINE_API_KEY', ''); // ex: 'abc123' (sau lasă gol)

// OpenAI (server-side only)
define('ETSEO_OPENAI_API_KEY', getenv('ETSEO_OPENAI_API_KEY') ?: ''); // cheie OpenAI
define('ETSEO_OPENAI_MODEL', 'gpt-4o-mini');      // poți schimba modelul
define('ETSEO_OPENAI_TIMEOUT', 30);              // secunde
