<?php
// etseo_engine_prompts.php
declare(strict_types=1);

function etseo_engine_safe_system_rules(): string {
    return implode("\n", [
        "Ești un specialist SEO on-page. Rulezi în SAFE MODE.",
        "NU modifici URL-uri, NU rescrii conținutul, NU schimbi heading-uri, NU inventezi informații.",
        "Generezi doar meta/OG/Twitter/canonical și JSON-LD sigur.",
        "Textele trebuie să fie în limba conținutului (RO dacă inputul e RO).",
        "Meta title 50–60 caractere, meta description 140–160 caractere (aprox).",
        "Dacă lipsește informația, folosește formulări generale, fără promisiuni și fără superlative nejustificate.",
        "Alege page_type: Product dacă post_type=product; Service pentru pagini de servicii; altfel Article/WebPage."
    ]);
}

function etseo_engine_safe_user_prompt(array $in): string {
    $url = (string)($in['url'] ?? '');
    $title = (string)($in['title'] ?? '');
    $excerpt = (string)($in['excerpt'] ?? '');
    $post_type = (string)($in['post_type'] ?? 'page');
    $content = (string)($in['content'] ?? '');

    // limităm conținutul trimis la AI (cost + siguranță)
    if (mb_strlen($content) > 2500) $content = mb_substr($content, 0, 2500);

    return <<<TXT
DATE PAGINĂ (SAFE):
- url: {$url}
- post_type: {$post_type}
- title: {$title}
- excerpt: {$excerpt}
- content_snippet: {$content}

CERINȚĂ:
Returnează strict JSON conform schemei. canonical trebuie să fie exact url-ul primit (fără #fragment). json_ld trebuie să fie un singur obiect JSON valid, serializat ca string.

TXT;
}
